package gov.va.med.mhv.journal.converter;

import gov.va.med.mhv.journal.data.model.FoodJournal;
import gov.va.med.mhv.journal.data.model.MealItem;
import gov.va.med.mhv.journal.dto.FoodJournalDTO;
import gov.va.med.mhv.journal.dto.MealItemDTO;
import gov.va.med.mhv.journal.web.util.JournalDecorator;

import java.util.HashSet;
import java.util.Set;

import org.springframework.stereotype.Component;

@Component
public class FoodJournalConverter {
	
	public FoodJournalDTO convertDomainFoodJournal(FoodJournal foodJournal) {
		FoodJournalDTO foodJournalDto = new FoodJournalDTO();
		
		foodJournalDto.setFoodJournalId(foodJournal.getFoodJournalId());
		foodJournalDto.setGlassesOfWater(foodJournal.getGlassesOfWater());
		foodJournalDto.setCreatedDate(foodJournal.getCreatedDate());
		foodJournalDto.setComments(foodJournal.getComments());
		foodJournalDto.setJournalDate(foodJournal.getJournalDate());
		foodJournalDto.setDayNoOfWeek(JournalDecorator.getDayNoOfWeek(foodJournal.getJournalDate()));
		foodJournalDto.setModifiedDate(foodJournal.getModifiedDate());

		if (null != foodJournal.getMealItems() && foodJournal.getMealItems().size() > 0) {
			Set<MealItemDTO> mealItemDtos = new HashSet<MealItemDTO>();
			for (MealItem mealItem : foodJournal.getMealItems()) {
				mealItemDtos.add(new MealItemConverter().convertDomainMealItem(mealItem));
			}
			foodJournalDto.setMealItems(mealItemDtos);
		}
		
		foodJournalDto.setUserId(foodJournal.getUserId());
		/*if (null != foodJournal.getUserProfile()) {
			foodJournalDto.setUserProfile(new UserProfileConverter().convertDomainUserProfile(foodJournal.getUserProfile()));
		}*/
		
		return foodJournalDto;
	}
	
	
	public FoodJournal convertDTOFoodJournal(FoodJournalDTO foodJournalDto) {
		FoodJournal foodJournal = new FoodJournal();
		
		foodJournal.setFoodJournalId(foodJournalDto.getFoodJournalId());
		foodJournal.setGlassesOfWater(foodJournalDto.getGlassesOfWater());
		foodJournal.setCreatedDate(foodJournalDto.getCreatedDate());
		foodJournal.setComments(foodJournalDto.getComments());
		foodJournal.setJournalDate(foodJournalDto.getJournalDate());
		foodJournal.setModifiedDate(foodJournalDto.getModifiedDate());

		Set<MealItem> mealItems = new HashSet<MealItem>();
		if (null != foodJournalDto.getMealItems() && foodJournalDto.getMealItems().size() > 0) {
			for (MealItemDTO mealItemDto : foodJournalDto.getMealItems()) {
				mealItems.add(new MealItemConverter().convertDTOMealItem(mealItemDto));
			}
		}
		foodJournal.setMealItems(mealItems);
		
		foodJournal.setUserId(foodJournalDto.getUserId());
		/*if (null != foodJournalDto.getUserProfile()) {
			foodJournal.setUserProfile(new UserProfileConverter().convertDTOProfile(new UserProfile(), foodJournalDto.getUserProfile()));
		}*/
		
		return foodJournal;
	}
}
